unit IWCompEdit32;

{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ELSE}
  {$IFDEF Linux}QControls, {$ELSE}Controls, {$ENDIF}
  {$ENDIF}
    {$IFDEF CLR}
    IWNetFileParser,
  {$ELSE}
    IWFileParser,
  {$ENDIF}
  {$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  Classes,
  IWControl32, IWColor, IWHTMLTag, IWRenderContext, IWBaseInterfaces;

type
  TIWCustomEdit32 = class(TIWCustomControl32, IIWInputControl)
  protected
    FPasswordPrompt: Boolean;
    FTagType: string;
    FMaxLength : integer;

    procedure SetValue(const AValue: string); virtual;
    procedure SetPasswordPrompt(const AValue: Boolean);

    procedure InitControl; override;

    property MaxLength : integer read FMaxLength write FMaxLength;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    property PasswordPrompt: Boolean read FPasswordPrompt write SetPasswordPrompt;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWEdit32.bmp}
  TIWEdit32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWEdit32), 'TIWEdit32.bmp')]
  {$ENDIF}
  TIWEdit32 = class(TIWCustomEdit32)
  public
    procedure Clear;
  published
    property PasswordPrompt;
    property MaxLength;
    property Text;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
  end;


  TIWFileButtonPosition = (ubpBelowEdit, ubpNextToBrowse);

  TIWCustomFile32 = class(TIWCustomControl32, IIWInputControl)
  protected
    FSubmitParam : String;
    FBGColor: TIWColor;
    FContentType: string;
    FFileName: string;
    FFile: THTTPFile;
    function GetContentType: string;
    function GetSize: Integer;
    procedure SetValue(const AValue: string); virtual;
    procedure SetFileValue(AFile: THTTPFile); override;

    procedure InitControl; override;
    procedure Submit(const AValue: string); override;
    procedure SetBGColor(const Value: TIWColor);

{$IFDEF CLR}
    strict protected
{$ELSE}
  protected
{$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function GetSubmitParam : String;
    procedure SaveToFile(AFilename: string = '');

    procedure SaveToStream(AStream: TStream);

    property ContentType: string read GetContentType;

    property Filename: string read FFileName;
    property BGColor: TIWColor read FBGColor write SetBGColor;
  published
    property TabOrder;
  end;
  
{$IFDEF VSNET}
{$R icons\Atozed.Intraweb.TIWFile32.bmp}
  TIWFile32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWFile32), 'TIWFile32.bmp')]
{$ENDIF}
  TIWFile32 = class(TIWCustomFile32)
  published
    property Enabled;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property BGColor;
  end;


implementation

uses
  SysUtils,
  SWSystem, IWBaseControl, IWTypes, IWException;

{ TIWCustomEdit32 }

procedure TIWCustomEdit32.InitControl;
begin
  inherited;
  Height := 21;
  Width := 121;
  FTagType := 'TEXT';
end;

function TIWCustomEdit32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; 
begin
  Result := nil;
  Result := TIWHTMLTag.CreateTag('INPUT');
  try
    Result.AddStringParam('TYPE', FTagType);
    Result.AddStringParam('NAME', HTMLName);
    if MaxLength > 0 then
    begin
      Result.AddIntegerParam('MAXLENGTH', MaxLength);
    end;
    Result.AddIntegerParam('SIZE', Width div 7);
    Result.AddStringParam('VALUE', TextToHTML(Text));
    // TODO: Does 3.2 support readonly?
  //  Result.Add(iif(ReadOnly, 'READONLY'));
  except
    FreeAndNil(Result);
    raise;
  end;
end;                                             

procedure TIWCustomEdit32.SetPasswordPrompt(const AValue: Boolean);
begin
  FTagType := IIF(AValue, 'PASSWORD', 'TEXT');
  FPasswordPrompt := AValue;
end;

procedure TIWCustomEdit32.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  Text := AValue;
  Invalidate;
end;

{ TIWEdit32 }

procedure TIWEdit32.Clear;
begin
  Text := '';
end;

{ TIWCustomFile32 }

procedure TIWCustomFile32.InitControl;
begin
  inherited;
  Width := 260;
  Height := 80;
  FFile := nil;
  ControlEncode := ceMPFormData;
  FBGColor := fromTColor(clNone);
end;

procedure TIWCustomFile32.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FFile);
  inherited;
end;

procedure TIWCustomFile32.SetFileValue(AFile: THTTPFile);
begin
  FreeAndNil(FFile);
  if Assigned(AFile) then begin
    FFile := THTTPFile.Create(AFile);
  end;
end;

procedure TIWCustomFile32.SetBGColor(const Value: TIWColor);
begin
  if FBGColor <> Value then
  begin
    FBGColor := Value;
    Invalidate;
  end;
end;

procedure TIWCustomFile32.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  FFilename := AValue;
end;

function TIWCustomFile32.RenderHTML(
  AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
//  EIWException.IfTrue((OwnerForm<>nil) and (OwnerForm.FormType = ftPage),'Can''t use TIWFile32 in Page-Mode.');
  Result := TIWHTMLTag.CreateTag('INPUT');
  try
    with Result do begin
      if not Enabled then begin
        AddBoolParam('DISABLED', True);
      end;
      AddStringParam('type', 'file');
      AddStringParam('name', HTMLName);
      if IsDesignMode or not Enabled then begin
        Add('DISABLED');
      end;
    end;
    TIWPageContext32(AContext.BasePageContext).FormTag.AddStringParam('ENCTYPE', 'multipart/form-data');
  except
    FreeAndNil(Result);
    raise;
  end;
end;

procedure TIWCustomFile32.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  // Does nothing just to protect from exception in ExecuteForm
end;

function TIWCustomFile32.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWCustomFile32.GetSize: Integer;
begin
  result := 0;
  if Assigned(FFile) then
    Result := FFile.Stream.Size;
end;

function TIWCustomFile32.GetContentType: string;
begin
  Result := '';
  if Assigned(FFile) then
    Result := FFile.ContentType;
end;

procedure TIWCustomFile32.SaveToFile(AFilename: string = '');
begin
  if AFileName = '' then begin
    AFileName := Filename;
  end;
  if Assigned(FFile) then begin
    FFile.SaveToFile(AFileName);
  end;
end;

procedure TIWCustomFile32.SaveToStream(AStream: TStream);
begin
  if Assigned(FFile) then begin
    FFile.SaveToStream(AStream);
  end;
end;

end.
